﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.UpdateClinic
{
    /// <summary>
    /// Create response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<UpdateClinicStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(UpdateClinicStateObject state)
        {
            try
            {
                state.ResponseMessage = new TmpHealthShareUpdateClinicResponseMessage { ExceptionOccured = false };
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Update Clinic CreateResponseStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}